; PLUGIN STEP 3: DEFPROTO
  (defproto vista-RewCat-proto 
  '(models-adjusted-list 
    vars 
    curr-model  
    terms 
    labels
    x-names
    x-matrix
    y-name
    y-vector
    excluded-categories
    data-object 
    model 
    be-hierarchic?
    variable-types
    blocks
    indicators-list) 
  () analysis-plugin-object-proto)


;; PLUGIN STEP 4: ISNEW


(defmeth vista-RewCat-proto :variable (&optional args)
  (send self :y-vector))

#|(defmeth vista-RewCat-proto :active-data-matrix (&optional args)
 (send *current-data* :active-data-matrix args))|#

(defmeth vista-RewCat-proto 
  :isnew (&rest args)
  (send self :model-abbrev (first args))
  (send self :dialog (select args 4))
  (send self :vars (select args 10))
  (send self :y-name (select args 8))
  (send self :y-vector (select args 9))
  (send self :model (list (select args 10)))
  (send self :variable-types (select args 13))
  (send self :labels (select args 7))
  (send self :excluded-categories nil) ;this could be used in the future
  (send self :x-matrix (select args 11))
  (send self :models-adjusted-list (select args 12))
  (send self :curr-model (car (list (select args 5))))
  (send self :terms (list (iseq (length (send self :vars))))) ;initial terms are just this
 ; (send self :model nil) ; This has to be completed (list (send self :list-terms))
  (send self :variable-types (select args 13))
  (send self :blocks (list (select args 14)))
  (send self :excluded-categories (list (select args 15)))
  
  (call-next-method "Regression with Categorical variables" (fourth args) "RewCat" '("class" "multivariate" "general" "bivariate")  *current-data* "Regression with Categorical variables" (fourth args) nil '(numeric category))
  
  )

; PLUGIN STEP 5: SLOT ACCESSORS

(defmeth vista-RewCat-proto :models-adjusted-list 
  (&optional (objects-list nil set))
"List of models previously fitted"
  (if set (setf (slot-value 'models-adjusted-list) objects-list))
  (slot-value 'models-adjusted-list))


(defmeth vista-RewCat-proto :vars 
  (&optional (variables-list nil set))
"List of variables in the data"
  (if set (setf (slot-value 'vars) variables-list))
  (slot-value 'vars))

(defmeth vista-RewCat-proto :curr-model 
  (&optional (object nil set))
"Current model fitted"
  (if set (setf (slot-value 'curr-model) object))
  (slot-value 'curr-model))


(defmeth vista-RewCat-proto :y-vector
  (&optional (y-vector nil set))
"Dependendent variable"
  (if set (setf (slot-value 'y-vector) y-vector))
  (slot-value 'y-vector))

(defmeth vista-RewCat-proto :terms
  (&optional (listterms nil set))
"Positions of terms in model"
  (if set (setf (slot-value 'terms) listterms))
  (slot-value 'terms))

(defmeth vista-RewCat-proto :model
  (&optional (model nil set))
"Positions of terms in model"
  (if set (setf (slot-value 'model) model))
  (slot-value 'model))

(defmeth vista-RewCat-proto :labels
  (&optional (labels nil set))
"Labels of observations"
  (if set (setf (slot-value 'labels) labels))
  (slot-value 'labels))

(defmeth vista-RewCat-proto :x-matrix
  (&optional (x-matrix nil set))
"Matrix of independent variables"
  (if set (setf (slot-value 'x-matrix) x-matrix))
  (slot-value 'x-matrix))

(defmeth vista-RewCat-proto :data
  (&optional (object nil set))
"Data object analyzed"
  (if set (setf (slot-value 'data) object))
  (slot-value 'data))


(defmeth vista-RewCat-proto :be-hierarchic?
  (&optional (be-hierarchic? nil set))
"This selects if the model works hierarchically"
  (if set (setf (slot-value 'be-hierarchic?) be-hierarchic?))
  (slot-value 'be-hierarchic?))

(defmeth vista-RewCat-proto :variable-types
  (&optional (variable-types nil set))
"Type of variables"
  (if set (setf (slot-value 'variable-types) variable-types))
  (slot-value 'variable-types))

(defmeth vista-RewCat-proto :y-name
  (&optional (y-name nil set))
"Name of dependent variables"
  (if set (setf (slot-value 'y-name) y-name))
  (slot-value 'y-name))

(defmeth vista-RewCat-proto :blocks
  (&optional (blocks nil set))
"Groups of terms"
  (if set (setf (slot-value 'blocks) blocks))
  (slot-value 'blocks))


(defmeth vista-RewCat-proto :excluded-categories
  (&optional (excluded-categories nil set))
"A list with the reference categories used"
  (if set (setf (slot-value 'excluded-categories) excluded-categories))
  #| (when excluded-categories (send self :level-labels
                                  (mapcar #'(lambda (cat label) 
                                      (combine cat (sort-data (remove cat label :test #'equal))))
                                      excluded-categories (send self :level-labels))))|#
  (slot-value 'excluded-categories)
  )
  

(defmeth vista-RewCat-proto :indicators-list
  (&optional (indicator nil set))
"Keeps a list of lists of names of indicators and values of the indicators added to the model window -ones or zeros-"
  (if set (setf (slot-value 'indicators-list) indicator))
  (slot-value 'indicators-list)) ;has to be checked

; PLUGIN STEP 6: OPTIONS METHOD
    ;Even though the options method is empty it has to be here.
  (defmeth vista-RewCat-proto :options ()
    )

; PLUGIN STEP 7: ANALYSIS METHOD
    ; This plugin is unusual because the analysis method is empty 
    ;and the analysis is carried out in the visualize method. 

(defmeth vista-RewCat-proto :analysis ()
    )

; PLUGIN STEP 8: REPORT METHOD

(defmeth vista-RewCat-proto :report (&key (dialog nil))
  (send (send self :curr-model) :display)
  )


; PLUGIN STEP 9: CREATE DATA

(defmeth vista-RewCat-proto  :create-data 
  (&key (dialog nil)
        (observed nil)
        (all t))
"Args: DIALOG (observed t) (all t)
Creates 1 or 2 output data objects. If DIALOG=T then presents dialog to determine which objects created. Otherwise presents specified objects. If no options, specified, creates both data objects."
  (if (not (eq current-object self)) (setcm self)) 
  (let* ((creator (send *desktop* :selected-icon))
         (curr-model (send self :curr-model))
         (design-matrix (send curr-model :x))
         (dep-var (send curr-model :y))
         (predicted (send curr-model :fit-means)); this has to be adapted to regression proto
         (chi-residuals (send curr-model :chi-residuals))
         (adj-chi-residuals (send curr-model :adj-chi-residuals))
         (leverages (send curr-model :leverages))
         (cooks-distances (send curr-model :cooks-distances))
         (matrix (bind-columns design-matrix 
                               dep-var 
                               predicted 
                               chi-residuals
                               adj-chi-residuals
                               leverages
                               cooks-distances))
         (vars (combine 
                (send self :predictor-names) 
                "Count"
                "Predicted"
                "Chi-residuals"
                "Adj-chi-residuals"
                "Leverages"
                "Cooks-distances"))
         (labels (send curr-model :case-labels))
         (numnum (length vars))
        )

    (data (send self :name)
          :created creator
          :creator-object self
          ;:freq (= type 0)
          :title (send self :title)
          :data (combine matrix)
          :variables vars
          :labels labels
          :types (repeat "Numeric" numnum)
    )))


(defmeth vista-RewCat-proto  :list-terms ()
  (let* ((terms (expand-hierarchy 
                (list (iseq (length (send self :vars))))))
     (temp-terms-cat (mapcar #'(lambda (ter) (select (send self :vars) ter))
                        terms))
     (terms-cat (mapcar #'(lambda (x) (apply 'strcat (car x)
                                             (mapcar #'(lambda (y) 
                                                         (strcat "|" y )) 
                                                     (cdr x))))
                        temp-terms-cat)))
    terms-cat))
         

(provide "logliplg")
